<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://https://yomomultimedia.com/
 * @since      1.0.0
 *
 * @package    Scrollbar_Style_Custom
 * @subpackage Scrollbar_Style_Custom/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Scrollbar_Style_Custom
 * @subpackage Scrollbar_Style_Custom/admin
 * @author     Yomo Multimedia <yomomultimedia@gmail.com>
 */
class Scrollbar_Style_Custom_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Scrollbar_Style_Custom_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Scrollbar_Style_Custom_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/scrollbar-style-custom-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Scrollbar_Style_Custom_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Scrollbar_Style_Custom_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/scrollbar-style-custom-admin.js', array( 'jquery' ), $this->version, false );

	}

}

class ScrollBarStyleCustom {
    private $scrollbar_style_custom_options;

    public function __construct() {
        add_action( 'admin_menu', array( $this, 'scrollbar_style_custom_add_plugin_page' ) );
        add_action( 'admin_init', array( $this, 'scrollbar_style_custom_page_init' ) );

        add_action( 'wp_enqueue_scripts', 'wpse_load_plugin_css' );

    }

    function wpse_load_plugin_css() {
   
		$plugin_url = plugin_dir_url( __FILE__ );

		wp_enqueue_style( 'stylescroll', $plugin_url . 'stylescroll.css' );

    }

    public function scrollbar_style_custom_add_plugin_page() {
        add_options_page(
            'ScrollBar Style Custom', // page_title
            'ScrollBar Style Custom', // menu_title
            'manage_options', // capability
            'scrollbar-style-custom', // menu_slug
            array( $this, 'scrollbar_style_custom_create_admin_page' ) // function
        );
    }

    public function scrollbar_style_custom_create_admin_page() {
        $this->scrollbar_style_custom_options = get_option( 'scrollbar_style_custom_option_name' );
        ?>

        <div class = 'wrap'>
        <h2>ScrollBar Style Custom</h2>
        <p>Personalizacion de la barra del navegador.</p>
        <?php settings_errors();
        ?>

        <form method = 'post' action = 'options.php'>
        <?php
        settings_fields( 'scrollbar_style_custom_option_group' );
        do_settings_sections( 'scrollbar-style-custom-admin' );
        submit_button();
        ?>
        </form>
        </div>
        <?php }

        public function scrollbar_style_custom_page_init() {
            register_setting(
                'scrollbar_style_custom_option_group', // option_group
                'scrollbar_style_custom_option_name', // option_name
                array( $this, 'scrollbar_style_custom_sanitize' ) // sanitize_callback
            );

            add_settings_section(
                'scrollbar_style_custom_setting_section', // id
                'Settings', // title
                array( $this, 'scrollbar_style_custom_section_info' ), // callback
                'scrollbar-style-custom-admin' // page
            );

            add_settings_field(
                'scrollbar_thumb_0', // id
                'Scrollbar Thumb', // title
                array( $this, 'scrollbar_thumb_0_callback' ), // callback
                'scrollbar-style-custom-admin', // page
                'scrollbar_style_custom_setting_section' // section
            );

            add_settings_field(
                'scrollbar_track_1', // id
                'Scrollbar Track', // title
                array( $this, 'scrollbar_track_1_callback' ), // callback
                'scrollbar-style-custom-admin', // page
                'scrollbar_style_custom_setting_section' // section
            );

            add_settings_field(
                'scrollbar_width_style_2', // id
                'Scrollbar Width Style', // title
                array( $this, 'scrollbar_width_style_2_callback' ), // callback
                'scrollbar-style-custom-admin', // page
                'scrollbar_style_custom_setting_section' // section
            );

            add_settings_field(
                'scrollbar_width_3', // id
                'Scrollbar Width', // title
                array( $this, 'scrollbar_width_3_callback' ), // callback
                'scrollbar-style-custom-admin', // page
                'scrollbar_style_custom_setting_section' // section
            );

            add_settings_field(
                'scrollbar_border_radius_4', // id
                'Scrollbar Border Radius', // title
                array( $this, 'scrollbar_border_radius_4_callback' ), // callback
                'scrollbar-style-custom-admin', // page
                'scrollbar_style_custom_setting_section' // section
            );

            add_settings_field(
                'scrollbar_border_width_5', // id
                'Scrollbar Border Width', // title
                array( $this, 'scrollbar_border_width_5_callback' ), // callback
                'scrollbar-style-custom-admin', // page
                'scrollbar_style_custom_setting_section' // section
            );

            add_settings_field(
                'scrollbar_border_style_6', // id
                'Scrollbar Border Style', // title
                array( $this, 'scrollbar_border_style_6_callback' ), // callback
                'scrollbar-style-custom-admin', // page
                'scrollbar_style_custom_setting_section' // section
            );

            add_settings_field(
                'scrollbar_border_color_7', // id
                'Scrollbar Border Color', // title
                array( $this, 'scrollbar_border_color_7_callback' ), // callback
                'scrollbar-style-custom-admin', // page
                'scrollbar_style_custom_setting_section' // section
            );
        }

        public function scrollbar_style_custom_sanitize( $input ) {
            $sanitary_values = array();
            if ( isset( $input[ 'scrollbar_thumb_0' ] ) ) {
                $sanitary_values[ 'scrollbar_thumb_0' ] = sanitize_text_field( $input[ 'scrollbar_thumb_0' ] );
            }

            if ( isset( $input[ 'scrollbar_track_1' ] ) ) {
                $sanitary_values[ 'scrollbar_track_1' ] = sanitize_text_field( $input[ 'scrollbar_track_1' ] );
            }

            if ( isset( $input[ 'scrollbar_width_style_2' ] ) ) {
                $sanitary_values[ 'scrollbar_width_style_2' ] = $input[ 'scrollbar_width_style_2' ];
            }

            if ( isset( $input[ 'scrollbar_width_3' ] ) ) {
                $sanitary_values[ 'scrollbar_width_3' ] = sanitize_text_field( $input[ 'scrollbar_width_3' ] );
            }

            if ( isset( $input[ 'scrollbar_border_radius_4' ] ) ) {
                $sanitary_values[ 'scrollbar_border_radius_4' ] = sanitize_text_field( $input[ 'scrollbar_border_radius_4' ] );
            }

            if ( isset( $input[ 'scrollbar_border_width_5' ] ) ) {
                $sanitary_values[ 'scrollbar_border_width_5' ] = sanitize_text_field( $input[ 'scrollbar_border_width_5' ] );
            }

            if ( isset( $input[ 'scrollbar_border_style_6' ] ) ) {
                $sanitary_values[ 'scrollbar_border_style_6' ] = $input[ 'scrollbar_border_style_6' ];
            }

            if ( isset( $input[ 'scrollbar_border_color_7' ] ) ) {
                $sanitary_values[ 'scrollbar_border_color_7' ] = sanitize_text_field( $input[ 'scrollbar_border_color_7' ] );
            }

            return $sanitary_values;
        }

        public function scrollbar_style_custom_section_info() {

        }

        public function scrollbar_thumb_0_callback() {
            printf(
                '<input class="regular-text" type="color" name="scrollbar_style_custom_option_name[scrollbar_thumb_0]" id="scrollbar_thumb_0" value="%s">',
                isset( $this->scrollbar_style_custom_options[ 'scrollbar_thumb_0' ] ) ? esc_attr( $this->scrollbar_style_custom_options[ 'scrollbar_thumb_0' ] ) : ''
            );
        }

        public function scrollbar_track_1_callback() {
            printf(
                '<input class="regular-text" type="color" name="scrollbar_style_custom_option_name[scrollbar_track_1]" id="scrollbar_track_1" value="%s">',
                isset( $this->scrollbar_style_custom_options[ 'scrollbar_track_1' ] ) ? esc_attr( $this->scrollbar_style_custom_options[ 'scrollbar_track_1' ] ) : ''
            );
        }

        public function scrollbar_width_style_2_callback() {
            ?> <select name = 'scrollbar_style_custom_option_name[scrollbar_width_style_2]' id = 'scrollbar_width_style_2'>
            <?php $selected = ( isset( $this->scrollbar_style_custom_options[ 'scrollbar_width_style_2' ] ) && $this->scrollbar_style_custom_options[ 'scrollbar_width_style_2' ] === 'none' ) ? 'selected' : '' ;
            ?>
            <option value = 'none' <?php echo $selected;
            ?>>None</option>
            <?php $selected = ( isset( $this->scrollbar_style_custom_options[ 'scrollbar_width_style_2' ] ) && $this->scrollbar_style_custom_options[ 'scrollbar_width_style_2' ] === 'thin' ) ? 'selected' : '' ;
            ?>
            <option value = 'thin' <?php echo $selected;
            ?>>Thin</option>
            <?php $selected = ( isset( $this->scrollbar_style_custom_options[ 'scrollbar_width_style_2' ] ) && $this->scrollbar_style_custom_options[ 'scrollbar_width_style_2' ] === 'auto' ) ? 'selected' : '' ;
            ?>
            <option value = 'auto' <?php echo $selected;
            ?>>Auto</option>
            </select> <?php
        }

        public function scrollbar_width_3_callback() {
            printf(
                '<div class="range-slider"><input class="regular-text range-slider__range" type="range" min="0" max="50" name="scrollbar_style_custom_option_name[scrollbar_width_3]" id="scrollbar_width_3" value="%s"> <span class="range-slider__value">0</span></div>',
                isset( $this->scrollbar_style_custom_options[ 'scrollbar_width_3' ] ) ? esc_attr( $this->scrollbar_style_custom_options[ 'scrollbar_width_3' ] ) : ''
            );
        }

        public function scrollbar_border_radius_4_callback() {
            printf(
                '<div class="range-slider"><input class="regular-text range-slider__range" type="range" min="0" max="50" name="scrollbar_style_custom_option_name[scrollbar_border_radius_4]" id="scrollbar_border_radius_4" value="%s"> <span class="range-slider__value">0</span></div>',
                isset( $this->scrollbar_style_custom_options[ 'scrollbar_border_radius_4' ] ) ? esc_attr( $this->scrollbar_style_custom_options[ 'scrollbar_border_radius_4' ] ) : ''
            );
        }

        public function scrollbar_border_width_5_callback() {
            printf(
                '<div class="range-slider"><input class="regular-text range-slider__range" type="range" min="0" max="50" name="scrollbar_style_custom_option_name[scrollbar_border_width_5]" id="scrollbar_border_width_5" value="%s"> <span class="range-slider__value">0</span></div>',
                isset( $this->scrollbar_style_custom_options[ 'scrollbar_border_width_5' ] ) ? esc_attr( $this->scrollbar_style_custom_options[ 'scrollbar_border_width_5' ] ) : ''
            );
        }

        public function scrollbar_border_style_6_callback() {
            ?> <select name = 'scrollbar_style_custom_option_name[scrollbar_border_style_6]' id = 'scrollbar_border_style_6'>
            <?php $selected = ( isset( $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] ) && $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] === 'none' ) ? 'selected' : '' ;
            ?>
            <option value = 'none' <?php echo $selected;
            ?>>None</option>
            <?php $selected = ( isset( $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] ) && $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] === 'dotted' ) ? 'selected' : '' ;
            ?>
            <option value = 'dotted' <?php echo $selected;
            ?>>Dotted</option>
            <?php $selected = ( isset( $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] ) && $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] === 'dashed' ) ? 'selected' : '' ;
            ?>
            <option value = 'dashed' <?php echo $selected;
            ?>>Dashed</option>
            <?php $selected = ( isset( $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] ) && $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] === 'solid' ) ? 'selected' : '' ;
            ?>
            <option value = 'solid' <?php echo $selected;
            ?>>Solid</option>
            <?php $selected = ( isset( $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] ) && $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] === 'double' ) ? 'selected' : '' ;
            ?>
            <option value = 'double' <?php echo $selected;
            ?>>Double</option>
            <?php $selected = ( isset( $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] ) && $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] === 'groove' ) ? 'selected' : '' ;
            ?>
            <option value = 'groove' <?php echo $selected;
            ?>>Groove</option>
            <?php $selected = ( isset( $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] ) && $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] === 'ridge' ) ? 'selected' : '' ;
            ?>
            <option value = 'ridge' <?php echo $selected;
            ?>>Ridge</option>
            <?php $selected = ( isset( $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] ) && $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] === 'inset' ) ? 'selected' : '' ;
            ?>
            <option value = 'inset' <?php echo $selected;
            ?>>Inset</option>
            <?php $selected = ( isset( $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] ) && $this->scrollbar_style_custom_options[ 'scrollbar_border_style_6' ] === 'outset' ) ? 'selected' : '' ;
            ?>
            <option value = 'outset' <?php echo $selected;
            ?>>Outset</option>
            </select> <?php
        }

        public function scrollbar_border_color_7_callback() {
            printf(
                '<input class="regular-text" type="color" name="scrollbar_style_custom_option_name[scrollbar_border_color_7]" id="scrollbar_border_color_7" value="%s">',
                isset( $this->scrollbar_style_custom_options[ 'scrollbar_border_color_7' ] ) ? esc_attr( $this->scrollbar_style_custom_options[ 'scrollbar_border_color_7' ] ) : ''
            );
        }

    }
    if ( is_admin() ) {

        $scrollbar_style_custom = new ScrollBarStyleCustom();

    }
