<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://https://yomomultimedia.com/
 * @since      1.0.0
 *
 * @package    Scrollbar_Style_Custom
 * @subpackage Scrollbar_Style_Custom/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Scrollbar_Style_Custom
 * @subpackage Scrollbar_Style_Custom/public
 * @author     Yomo Multimedia <yomomultimedia@gmail.com>
 */
class Scrollbar_Style_Custom_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Scrollbar_Style_Custom_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Scrollbar_Style_Custom_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/scrollbar-style-custom-public.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Scrollbar_Style_Custom_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Scrollbar_Style_Custom_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/scrollbar-style-custom-public.js', array( 'jquery' ), $this->version, false );

	}

	

}


add_Action( 'wp_head', 'my_head_css' );

function my_head_css() {

	$scrollbar_style_custom_options = get_option( 'scrollbar_style_custom_option_name' );
	// Array of All Options

	$scrollbar_thumb_0 = $scrollbar_style_custom_options[ 'scrollbar_thumb_0' ];
	// Scrollbar Thumb
	$scrollbar_track_1 = $scrollbar_style_custom_options[ 'scrollbar_track_1' ];
	// Scrollbar Track
	$scrollbar_width_style_2 = $scrollbar_style_custom_options[ 'scrollbar_width_style_2' ];
	// Scrollbar Width Style
	$scrollbar_width_3 = $scrollbar_style_custom_options[ 'scrollbar_width_3' ].'px';
	// Scrollbar Width
	$scrollbar_border_radius_4 = $scrollbar_style_custom_options[ 'scrollbar_border_radius_4' ].'px';
	// Scrollbar Border Radius
	$scrollbar_border_width_5 = $scrollbar_style_custom_options[ 'scrollbar_border_width_5' ].'px';
	// Scrollbar Border Width
	$scrollbar_border_style_6 = $scrollbar_style_custom_options[ 'scrollbar_border_style_6' ];
	// Scrollbar Border Style
	$scrollbar_border_color_7 = $scrollbar_style_custom_options[ 'scrollbar_border_color_7' ];
	// Scrollbar Border Color

	echo "<style>

* {
scrollbar-width: $scrollbar_width_style_2;
scrollbar-color: $scrollbar_thumb_0 $scrollbar_track_1;
}

/* Chrome, Edge, and Safari */
*::-webkit-scrollbar {
width: $scrollbar_width_3;
}

*::-webkit-scrollbar-track {
background: $scrollbar_track_1;
}

*::-webkit-scrollbar-thumb {
background-color: $scrollbar_thumb_0;
border-radius: $scrollbar_border_radius_4;
border: $scrollbar_border_width_5 $scrollbar_border_style_6 $scrollbar_border_color_7;
}

</style>
";
}
