<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://https://yomomultimedia.com/
 * @since      1.0.0
 *
 * @package    Scrollbar_Style_Custom
 * @subpackage Scrollbar_Style_Custom/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Scrollbar_Style_Custom
 * @subpackage Scrollbar_Style_Custom/includes
 * @author     Yomo Multimedia <yomomultimedia@gmail.com>
 */
class Scrollbar_Style_Custom_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'scrollbar-style-custom',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
