<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://https://yomomultimedia.com/
 * @since             1.0.0
 * @package           Scrollbar_Style_Custom
 *
 * @wordpress-plugin
 * Plugin Name:       ScrollBar Style Custom
 * Plugin URI:        https://https://yomomultimedia.com/
 * Description:       Personalizacion de barra de scroll
 * Version:           1.0.0
 * Author:            Yomo Multimedia
 * Author URI:        https://https://yomomultimedia.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       scrollbar-style-custom
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'SCROLLBAR_STYLE_CUSTOM_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-scrollbar-style-custom-activator.php
 */
function activate_scrollbar_style_custom() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-scrollbar-style-custom-activator.php';
	Scrollbar_Style_Custom_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-scrollbar-style-custom-deactivator.php
 */
function deactivate_scrollbar_style_custom() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-scrollbar-style-custom-deactivator.php';
	Scrollbar_Style_Custom_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_scrollbar_style_custom' );
register_deactivation_hook( __FILE__, 'deactivate_scrollbar_style_custom' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-scrollbar-style-custom.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_scrollbar_style_custom() {

	$plugin = new Scrollbar_Style_Custom();
	$plugin->run();

}
run_scrollbar_style_custom();
