<?php
namespace Elementor;

class Css_Checkbox_Radio extends Widget_Base {

    /**
    * Get widget name.
    * @since 1.0.0
    * @access public
    *
    * @return string Widget name.
    */

    public function get_name() {
        return 'css-checkbox-radio';
    }

    /**
    * Get widget title.
    * @since 1.0.0
    * @access public
    *
    * @return string Widget title.
    */

    public function get_title() {
        return 'Css CheckBox Radio';
    }

    /**
    * Get widget icon.
    * @since 1.0.0
    * @access public
    *<i class = 'fa-regular fa-square-check'></i>
    * @return string Widget icon.
    */

    public function get_icon() {
        return 'eicon-checkbox';
    }

    /**
    * Get widget categories.
    * @since 1.0.0
    * @access public
    *
    * @return array Widget categories.
    */

    public function get_categories() {
        return [ 'yomomultimedia' ];
    }

    public function get_keywords() {
        return [ 'yomo', 'checkbox', 'radio', 'form' ];
    }

    /**
    * Register widget controls.
    * @since 1.0.0
    * @access protected
    */
    protected function _register_controls() {

        /**
        *  Here you can add your controls. The controls below are only examples.
        *  Check this: https://developers.elementor.com/elementor-controls/
        *
        **/
        $this->start_controls_section(
            'container',
            [
                'label' => __( 'Container', 'yomo-toggle-elementor-checkbox-radio' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'containerpadding',
            [
                'label' => esc_html__( 'Padding', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'default' => [
                    'top' => 3,
                    'right' => 3,
                    'bottom' => 3,
                    'left' => 3,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-subgroup,.elementor-field-option' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'containermargin',
            [
                'label' => esc_html__( 'Margen', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'default' => [
                    'top' => 3,
                    'right' => 3,
                    'bottom' => 3,
                    'left' => 3,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-subgroup,.elementor-field-option' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'containercolorfondo',
            [
                'label' => esc_html__( 'Color Fondo', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff00!important',
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-subgroup,.elementor-field-option' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
        //Base//////////////////////////////////////////////////////////////////////////////////////
        $this->start_controls_section(
            'base',
            [
                'label' => __( 'Base', 'yomo-toggle-elementor-checkbox-radio' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'basecolor',
            [
                'label' => esc_html__( 'Color', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#E5E5E59E',
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,[ type = "checkbox" ],[ type = "radio" ]' => 'background-color: {{VALUE}}!important;',
                ],
            ]
        );
        $this->add_control(
            'basepadding',
            [
                'label' => esc_html__( 'Padding', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'default' => [
                    'top' => 4,
                    'right' => 12,
                    'bottom' => 4,
                    'left' => 12,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,[ type = "checkbox" ],[ type = "checkbox" ]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                    '{{WRAPPER}} .elementor-field-option,[ type = "radio" ],[ type = "radio" ]'=> 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
            ]
        );
        $this->add_control(
            'basebordestyle',
            [
                'label' => esc_html__( 'Border Estilo', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => [
                    '' => esc_html__( 'Default', 'textdomain' ),
                    'none' => esc_html__( 'None', 'textdomain' ),
                    'solid'  => esc_html__( 'Solid', 'textdomain' ),
                    'dashed' => esc_html__( 'Dashed', 'textdomain' ),
                    'dotted' => esc_html__( 'Dotted', 'textdomain' ),
                    'double' => esc_html__( 'Double', 'textdomain' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,[ type = "checkbox" ],[ type = "checkbox" ]' => 'border-style: {{VALUE}}!important;',
                    '{{WRAPPER}} .elementor-field-option,[ type = "radio" ],[ type = "radio" ]' => 'border-style: {{VALUE}}!important;',
                ],
            ]
        );
        $this->add_control(
            'baseanchoborde',
            [
                'label' => esc_html__( 'Ancho Borde', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 20,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,[ type = "checkbox" ],[ type = "radio" ]' => 'border-width: {{SIZE}}{{UNIT}}!important;',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'basebordecolor',
            [
                'label' => esc_html__( 'Color Border', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#7FCBFFED',
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,[ type = "checkbox" ],[ type = "radio" ]' => 'border-color: {{VALUE}}!important;',
                ],
            ]
        );

        $this->add_control(
            'baseradius',
            [
                'label' => esc_html__( 'Radius', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 6,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,[ type = "checkbox" ]' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                    '{{WRAPPER}} .elementor-field-option,[ type = "radio" ]' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                    '{{WRAPPER}} .elementor-field-option,input[ type = "checkbox" ], input[ type = "radio" ]:focus' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                    '{{WRAPPER}} .elementor-field-option,input[ type = "checkbox" ], input[ type = "radio" ]:focus:not' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->end_controls_section();

        //check//////////////////////////////////////////////////////////////////////////////////////

        $this->start_controls_section(
            'Checked_',
            [
                'label' => __( 'Check', 'yomo-toggle-elementor-checkbox-radio' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'checkdancho',
            [
                'label' => esc_html__( 'Ancho', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'rem',
                    'size' => 1.3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,[ type = "checkbox" ]:before' => 'width: {{SIZE}}{{UNIT}}!important;',
                    '{{WRAPPER}} .elementor-field-option,[ type = "radio" ]:before' => 'width: {{SIZE}}{{UNIT}}!important;',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'checkdalto',
            [
                'label' => esc_html__( 'Alto', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'rem',
                    'size' => 1.4,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,[ type = "checkbox" ]:before' => 'height: {{SIZE}}{{UNIT}}!important;',
                    '{{WRAPPER}} .elementor-field-option,[ type = "radio" ]:before' => 'height: {{SIZE}}{{UNIT}}!important;',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'chekedradius',
            [
                'label' => esc_html__( 'Radius', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 4,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input[ type = "checkbox" ]:before,input[ type = "radio" ]:before' => 'border-radius: {{SIZE}}{{UNIT}}!important;',

                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'Checkcolorfondo',
            [
                'label' => esc_html__( 'Color Fondo', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#6ACEEF!important',
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input[ type = "checkbox" ]:checked:before,input[ type = "radio" ]:checked:before' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'labelcheck',
            [
                'label' => __( 'Label', 'yomo-toggle-elementor-checkbox-radio' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'labelsize',
            [
                'label' => esc_html__( 'Tamaño', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input[type="radio"] + label,input[type="checkbox"] + label ' => 'font-size: {{SIZE}}{{UNIT}}!important;',

                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'labelcolor',
            [
                'label' => esc_html__( 'Color', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#32A4C5FA!important',
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input[type="radio"] + label,input[type="checkbox"] + label ' =>'color: {{VALUE}}!important;',
                ],
            ]
        );

        $this->end_controls_section();

    }
    //fin base

    /**
    * Render widget output on the frontend.
    *
    * Written in PHP and used to generate the final HTML.
    *
    * @since 1.0.0
    * @access protected
    */

    protected function render() {

        $settings = $this->get_settings_for_display();

        /**
        *  Here you can output your control data and build your content.
        **/
        // echo esc_attr( $settings[ 'baseancho' ][ 'size' ] .$settings[ 'baseancho' ][ 'unit' ] ) .'<br>';

        // print_r( $settings[ 'baseancho' ] );
        ?>
        <style>
        input[ type = 'checkbox' ],
        input[ type = 'radio' ] {
            aspect-ratio: 1;
            appearance: none;
            outline: none;
            cursor: pointer;
            position: relative;
            margin: 10px 10px 10px 10px !important;
        }
        /*LAbel*/
        input[ type = 'radio' ]+label,
        input[ type = 'checkbox' ]+label {
            cursor: pointer;
        }
        /*  Check   */
        input[ type = 'checkbox' ]:before,
        input[ type = 'radio' ]:before {
            content: '';
            position: absolute;
            top: 0.2rem !important;
            left: 0.1rem !important;
            transform: scale( 0 );
            transition: all .3s;
        }
        input[ type = 'checkbox' ]:checked:before,
        input[ type = 'radio' ]:checked:before {
            transform: scale( 1 );
        }
        input[ type = 'checkbox' ].opacity:before,
        input[ type = 'radio' ].opacity:before {
            transform: scale( 1 );
            opacity: 0;
        }
        input[ type = 'checkbox' ].opacity:checked:before,
        input[ type = 'radio' ].opacity:checked:before {
            opacity: 1;
        }

        </style>

        <?php

    }

    /**
    * Written as a Backbone JavaScript template and used to generate the live preview.
    * With JS templates we don’t really need to retrieve the data using a special function, its done by Elementor for us.
    * The data from the controls stored in the settings variable.
    */
    protected function _content_template() {
        ?>
  
        <!-- Here you can add your custom HTML output.
        You can use all field variables you created above. -->
        <style>



        input[ type = 'checkbox' ],
        input[ type = 'radio' ] {
            aspect-ratio: 1;
            appearance: none;
            outline: none;
            cursor: pointer;
            position: relative;
            margin: 10px 10px 10px 10px !important;
        }
        /*LAbel*/
        input[ type = 'radio' ]+label,
        input[ type = 'checkbox' ]+label {
            cursor: pointer;
        }
        /*  Check   */
        input[ type = 'checkbox' ]:before,
        input[ type = 'radio' ]:before {
            content: '';
            position: absolute;
            top: 0.2rem !important;
            left: 0.1rem !important;
            transform: scale( 0 );
            transition: all .3s;
        }
        input[ type = 'checkbox' ]:checked:before,
        input[ type = 'radio' ]:checked:before {
            transform: scale( 1 );
        }
        input[ type = 'checkbox' ].opacity:before,
        input[ type = 'radio' ].opacity:before {
            transform: scale( 1 );
            opacity: 0;
        }
        input[ type = 'checkbox' ].opacity:checked:before,
        input[ type = 'radio' ].opacity:checked:before {
            opacity: 1;
        }

        </style>

        <?php
    }
}

