<?php
namespace Elementor;

class Toggle_Checkbox_Radio extends Widget_Base {

    /**
    * Get widget name.
    * @since 1.0.0
    * @access public
    *
    * @return string Widget name.
    */

    public function get_name() {
        return 'Toggle-checkbox-radio';
    }

    /**
    * Get widget title.
    * @since 1.0.0
    * @access public
    *
    * @return string Widget title.
    */

    public function get_title() {
        return 'Toggle CheckBox Radio';
    }

    /**
    * Get widget icon.
    * @since 1.0.0
    * @access public
    *<i class = 'fa-solid fa-toggle-off'></i>
    * @return string Widget icon.
    */

    public function get_icon() {
        return 'eicon-check';
    }

    /**
    * Get widget categories.
    * @since 1.0.0
    * @access public
    *
    * @return array Widget categories.
    */

    public function get_categories() {
        return [ 'yomomultimedia' ];
    }

    public function get_keywords() {
        return [ 'yomo', 'toggle', 'form' ];
    }
    /**
    * Register widget controls.
    * @since 1.0.0
    * @access protected
    */
    protected function _register_controls() {

        /**
        *  Here you can add your controls. The controls below are only examples.
        *  Check this: https://developers.elementor.com/elementor-controls/
        *
        **/

        $this->start_controls_section(
            'container',
            [
                'label' => __( 'Container', 'yomo-toggle-elementor-checkbox-radio' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'containerpadding',
            [
                'label' => esc_html__( 'Padding', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'default' => [
                    'top' => 3,
                    'right' => 3,
                    'bottom' => 3,
                    'left' => 3,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-subgroup,.elementor-field-option' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'containermargin',
            [
                'label' => esc_html__( 'Margen', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'default' => [
                    'top' => 3,
                    'right' => 3,
                    'bottom' => 3,
                    'left' => 3,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-subgroup,.elementor-field-option' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'containercolorfondo',
            [
                'label' => esc_html__( 'Color Fondo', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF00!important',
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-subgroup,.elementor-field-option' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'containerborderradius',
            [
                'label' => esc_html__( 'Radius', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 2,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-subgroup,.elementor-field-option' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'containerborde',
            [
                'label' => esc_html__( 'Ancho Borde', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 35,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 2,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-subgroup,.elementor-field-option' =>  'border-width: {{SIZE}}{{UNIT}}!important;',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'containercolorborde',
            [
                'label' => esc_html__( 'Color Borde', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF00',
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-subgroup,.elementor-field-option' => 'border-color: {{VALUE}}!important;',

                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'base',
            [
                'label' => __( 'Base', 'yomo-toggle-elementor-checkbox-radio' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'baseancho',
            [
                'label' => esc_html__( 'Ancho', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input[type="radio"]' => 'width: {{SIZE}}{{UNIT}}!important;',
                    '{{WRAPPER}} .elementor-field-option,input[type="checkbox"]' => 'width: {{SIZE}}{{UNIT}}!important;',

                ],
                'dynamic' => [
                    'active' => true,
                ],

            ]
        );
        $this->add_control(
            'basealto',
            [
                'label' => esc_html__( 'Alto', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 25,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input[type="radio"]' => 'height: {{SIZE}}{{UNIT}}!important;',
                    '{{WRAPPER}} .elementor-field-option,input[type="checkbox"]' => 'height: {{SIZE}}{{UNIT}}!important;',
                ],
                'dynamic' => [
                    'active' => true,
                ],

            ]
        );

        $this->add_control(
            'baseradius',
            [
                'label' => esc_html__( 'Radius', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input[type="radio"]' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                    '{{WRAPPER}} .elementor-field-option,input[type="checkbox"]' => 'border-radius: {{SIZE}}{{UNIT}}!important;',

                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'basecolor',
            [
                'label' => esc_html__( 'Color Fondo', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#E2F6FFF0',
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input[type="radio"]' => 'background-color: {{VALUE}}!important;',
                    '{{WRAPPER}} .elementor-field-option,input[type="checkbox"]' => 'background-color: {{VALUE}}!important;',
                ],
            ]
        );

        $this->add_control(
            'basefondoactivo',
            [
                'label' => esc_html__( 'Color Fondo Activo', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#4dc1ff',
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input:checked[type="radio"]' => 'background-color: {{VALUE}}!important;',
                    '{{WRAPPER}} .elementor-field-option,input:checked[type="checkbox"]' => 'background-color: {{VALUE}}!important;',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'toggle',
            [
                'label' => __( 'Toggle', 'yomo-toggle-elementor-checkbox-radio' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'toggleancho',
            [
                'label' => esc_html__( 'Ancho', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 25,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input[type="radio"]:before' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .elementor-field-option,input[type="checkbox"]:before' => 'width: {{SIZE}}{{UNIT}};',

                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'togglealto',
            [
                'label' => esc_html__( 'Alto', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 25,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input[type="radio"]:before' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .elementor-field-option,input[type="checkbox"]:before' => 'height: {{SIZE}}{{UNIT}};',

                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'toggleradius',
            [
                'label' => esc_html__( 'Radius', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 20,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input[type="radio"]:before' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
                    '{{WRAPPER}} .elementor-field-option,input[type="checkbox"]:before' => 'border-radius: {{SIZE}}{{UNIT}}!important;',

                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'togglecolorfondo',
            [
                'label' => esc_html__( 'Color Fondo', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input[ type = "radio" ]:before' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .elementor-field-option,input[type="checkbox"]:before' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'toggleborde',
            [
                'label' => esc_html__( 'Ancho Borde', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 35,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input[type="radio"]:before' => 'border-width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .elementor-field-option,input[type="checkbox"]:before' => 'border-width: {{SIZE}}{{UNIT}};',

                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'togglecolorborde',
            [
                'label' => esc_html__( 'Color Borde', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3E85AB',
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input[ type = "radio" ]:before' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .elementor-field-option,input[type="checkbox"]:before' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'animacion',
            [
                'label' => esc_html__( 'Animación', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'desktop_default' => [
                    'size' => 25,
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'size' => 25,
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'size' => 25,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input:checked[ type = "radio" ]:before' => 'left: {{SIZE}}{{UNIT}}!important;',
                    '{{WRAPPER}} .elementor-field-option,input:checked[ type = "checkbox" ]:before' => 'left: {{SIZE}}{{UNIT}}!important;',

                ],
                'dynamic' => [
                    'active' => true,
                ],
                'frontend_available' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'label',
            [
                'label' => esc_html__( 'Label', 'textdomain' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'labelflex',
            [
                'label' => esc_html__( 'Label Flex Position', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'row',
                'options' => [
                    'row' => esc_html__( 'Row', 'textdomain' ),
                    'column'  => esc_html__( 'Column', 'textdomain' ),
                    'row-reverse' => esc_html__( 'Row-Reverse', 'textdomain' ),
                    'column-reverse' => esc_html__( 'Column-Reverse', 'textdomain' ),

                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-subgroup,.elementor-field-option' => 'flex-direction: {{VALUE}}!important;',
                ],
            ]
        );

        $this->add_control(
            'labelmargen',
            [
                'label' => esc_html__( 'Margen', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'default' => [
                    'top' => 2,
                    'right' => 2,
                    'bottom' => 2,
                    'left' => 2,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
            ]
        );

        $this->add_control(
            'labelsize',
            [
                'label' => esc_html__( 'Tamaño', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input[type="radio"] + label,input[type="checkbox"] + label ' => 'font-size: {{SIZE}}{{UNIT}}!important;',

                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'labelcolor',
            [
                'label' => esc_html__( 'Color', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#32A4C5FA',
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input[type="radio"] + label,input[type="checkbox"] + label' =>'color: {{VALUE}}!important;',
                ],
            ]
        );
        $this->add_control(
            'labelcolorlink',
            [
                'label' => esc_html__( 'Color', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#236781',
                'selectors' => [
                    '{{WRAPPER}} .elementor-field-option,input[type="radio"] + label a,input[type="checkbox"] + label a' =>'color: {{VALUE}}!important;',
                ],
            ]
        );


     



        $this->end_controls_section();

    }
    //fin base

    /**
    * Render widget output on the frontend.
    *
    * Written in PHP and used to generate the final HTML.
    *
    * @since 1.0.0
    * @access protected
    */

    protected function render() {

        $settings = $this->get_settings_for_display();

        /**
        *  Here you can output your control data and build your content.
        **/
        // echo esc_attr( $settings[ 'baseancho' ][ 'size' ] .$settings[ 'baseancho' ][ 'unit' ] ) .'<br>';

        // print_r( $settings[ 'baseancho' ] );
        ?>
        <style>
        input[ type = 'radio' ], input[ type = 'checkbox' ] {
            position: relative !important;
            -webkit-appearance: none !important;
            outline: none !important;
            box-shadow: inset 0 0 5px rgba( 0, 0, 0, 0.20 ) !important;
            transition: 0.7s !important;

        }
        input[ type = 'radio' ]:before, input[ type = 'checkbox' ]:before {
            content: '' !important;
            position: absolute !important;
            top: 0 !important;
            left: 0 !important;
            transform: scale( 1.1 ) !important;
            box-shadow: 0 2px 5px rgba( 0, 0, 0, 0.2 ) !important;
            transition: .4s !important;
            border-style: solid !important;
        }
        .elementor-field-type-acceptance .elementor-field-subgroup .elementor-field-option input,
        .elementor-field-type-acceptance .elementor-field-subgroup .elementor-field-option label,
        .elementor-field-type-checkbox .elementor-field-subgroup .elementor-field-option input,
        .elementor-field-type-checkbox .elementor-field-subgroup .elementor-field-option label,
        .elementor-field-type-radio .elementor-field-subgroup .elementor-field-option input,
        .elementor-field-type-radio .elementor-field-subgroup .elementor-field-option label {
            display: block !important;
        }
        span.elementor-field-option {
            display: flex;
            flex-direction: column-reverse;
        }
        .elementor-field-option {
            border-style: solid !important;
        }
        input[ type = 'radio' ], input[ type = 'checkbox' ] {
            cursor: pointer !important;
        }
        input[ type = 'radio' ]+label, input[ type = 'checkbox' ]+label {
            cursor: pointer !important;
        }
        input[ type = 'radio' ], input[ type = 'checkbox' ] {
            cursor: pointer !important;
        }
        input[ type = 'radio' ]+label, input[ type = 'checkbox' ]+label {
            cursor: pointer !important;
        }

        </style>

        <?php

    }

    /**
    * Written as a Backbone JavaScript template and used to generate the live preview.
    * With JS templates we don’t really need to retrieve the data using a special function, its done by Elementor for us.
    * The data from the controls stored in the settings variable.
    */
    protected function _content_template() {
        ?>

        <!-- Here you can add your custom HTML output.
        You can use all field variables you created above. -->
        <style>
        input[ type = 'radio' ], input[ type = 'checkbox' ] {
            position: relative !important;
            -webkit-appearance: none !important;
            outline: none !important;
            box-shadow: inset 0 0 5px rgba( 0, 0, 0, 0.20 ) !important;
            transition: 0.7s !important;

        }
        input[ type = 'radio' ]:before, input[ type = 'checkbox' ]:before {
            content: '' !important;
            position: absolute !important;
            top: 0 !important;
            left: 0 !important;
            transform: scale( 1.1 ) !important;
            box-shadow: 0 2px 5px rgba( 0, 0, 0, 0.2 ) !important;
            transition: .4s !important;
            border-style: solid !important;
        }
        .elementor-field-type-acceptance .elementor-field-subgroup .elementor-field-option input,
        .elementor-field-type-acceptance .elementor-field-subgroup .elementor-field-option label,
        .elementor-field-type-checkbox .elementor-field-subgroup .elementor-field-option input,
        .elementor-field-type-checkbox .elementor-field-subgroup .elementor-field-option label,
        .elementor-field-type-radio .elementor-field-subgroup .elementor-field-option input,
        .elementor-field-type-radio .elementor-field-subgroup .elementor-field-option label {
            display: block !important;
        }
        span.elementor-field-option {
            display: flex;
            flex-direction: column-reverse;
        }
        .elementor-field-option {
            border-style: solid !important;
        }
        input[ type = 'radio' ], input[ type = 'checkbox' ] {
            cursor: pointer !important;
        }
        input[ type = 'radio' ]+label, input[ type = 'checkbox' ]+label {
            cursor: pointer !important;
        }
        input[ type = 'radio' ], input[ type = 'checkbox' ] {
            cursor: pointer !important;
        }
        input[ type = 'radio' ]+label, input[ type = 'checkbox' ]+label {
            cursor: pointer !important;
        }

        </style>

        <?php
    }
}

