<?php
/*
Plugin Name: Yomo Custom Elementor CheckBox Radio
Description: Diseño personalizado para input CheckBox y Radio con el editor de Elementor!.
Author: Yomo Multiemdia
Version: 1.0.0
Plugin URI: https://yomomultimedia.com/pagina-descarga/yomo-custom-elementor-checkbox-radio/
Author URI:  https://yomomultimedia.com/
License: GPL
*/


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

final class Yomo_Custom_Elementor_Checkbox_Radio {

	/**
	 * Plugin Version
	 *
	 * @since 1.0.0
	 *
	 * @var string The plugin version.
	 */
	const VERSION = '1.0.0';

	/**
	 * Minimum Elementor Version
	 *
	 * @since 1.0.0
	 *
	 * @var string Minimum Elementor version required to run the plugin.
	 */
	const MINIMUM_ELEMENTOR_VERSION = '2.5.11';

	/**
	 * Minimum PHP Version
	 *
	 * @since 1.0.0
	 *
	 * @var string Minimum PHP version required to run the plugin.
	 */
	const MINIMUM_PHP_VERSION = '6.0';

	/**
	 * Instance
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 * @static
	 *
	 * The single instance of the class.
	 */
	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */

	protected function __construct() {
		// Check if Elementor installed and activated
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
			return;
		}
		// Check for required PHP version
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
			return;
		}

		require_once('widgets/toggle-checkbox-radio/toggle-checkbox-radio.php');
		require_once('widgets/css-checkbox-radio/css-checkbox-radio.php');

		// Register Widget
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );

		// Register Widget Styles
		add_action( 'elementor/frontend/after_enqueue_styles', [ $this, 'widget_styles' ] );

		// Register Widget Scripts
		add_action( 'elementor/frontend/after_enqueue_scripts', [ $this, 'widget_scripts' ] );

	}


	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Toggle_Checkbox_Radio() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Css_Checkbox_Radio() );

	}

	public function widget_styles() {
		wp_enqueue_style( 'toggle-checkbox-radio-css', plugins_url( 'widgets/toggle-checkbox-radio/css/toggle-checkbox-radio.css', __FILE__ ) );
		wp_enqueue_style( 'css-checkbox-radio-css', plugins_url( 'widgets/css-checkbox-radio/css/css-checkbox-radio.css', __FILE__ ) );
	}

	public function widget_scripts() {
		wp_enqueue_script( 'toggle-checkbox-radio-js', plugins_url( 'widgets/toggle-checkbox-radio/js/toggle-checkbox-radio.js', __FILE__ ), array( 'jquery' ) );
		wp_enqueue_script( 'css-checkbox-radio-js', plugins_url( 'widgets/css-checkbox-radio/js/css-checkbox-radio.js', __FILE__ ), array( 'jquery' ) );
	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have Elementor installed or activated.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function admin_notice_missing_main_plugin() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
		/* 1: Plugin name 2: Elementor */
			esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'yomo-toggle-elementor-checkbox-radio' ),
			'<strong>' . esc_html__( 'Yomo Toggle Elementor CheckBox Radio', 'yomo-toggle-elementor-checkbox-radio' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'yomo-toggle-elementor-checkbox-radio' ) . '</strong>'
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have a minimum required Elementor version.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function admin_notice_minimum_elementor_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
		/* 1: Plugin name 2: Elementor 3: Required Elementor version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'yomo-toggle-elementor-checkbox-radio' ),
			'<strong>' . esc_html__( 'Yomo Toggle Elementor CheckBox Radio', 'yomo-toggle-elementor-checkbox-radio' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'yomo-toggle-elementor-checkbox-radio' ) . '</strong>',
			self::MINIMUM_ELEMENTOR_VERSION
		);
		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have a minimum required PHP version.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function admin_notice_minimum_php_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
		/* 1: Plugin name 2: PHP 3: Required PHP version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'yomo-toggle-elementor-checkbox-radio' ),
			'<strong>' . esc_html__( 'Yomo Toggle Elementor CheckBox Radio', 'yomo-toggle-elementor-checkbox-radio' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'yomo-toggle-elementor-checkbox-radio' ) . '</strong>',
			self::MINIMUM_PHP_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

}

add_action( 'init', 'Yomo_Custom_Elementor_Checkbox_Radio_elementor_init' );
function Yomo_Custom_Elementor_Checkbox_Radio_elementor_init() {
	Yomo_Custom_Elementor_Checkbox_Radio::get_instance();
}
//categoria
function add_elementor_widget_categories_yomo( $elements_manager ) {

	$elements_manager->add_category(
		'yomomultimedia',
		[
			'title' => esc_html__( 'Yomo multimedia', 'textdomain' ),
			'icon' => 'fa fa-plug',
		]
	);


}
add_action( 'elementor/elements/categories_registered', 'add_elementor_widget_categories_yomo' );

    